jQuery(document).ready(function(){

    jQuery('.js-example-basic-multiple').select2();

    jQuery("#my_status_customer_id").keypress(function (e) {
        //if the letter is not digit then display error and don't type anything
        if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
           //display error message
            return false;
       }
    });

    
    var wordLen = 30,
    len; // Maximum word length
    
    if(jQuery('#word_count').val() != '' && typeof jQuery('#word_count').val() !== 'undefined' ){        
        len = jQuery('#word_count').val().split(/[\s]+/);
        wordsLeft = (wordLen) - len.length;
        jQuery('#display_count').html(wordsLeft+ ' words left');
    }
    
    jQuery('#word_count').keydown(function(event) {	
	var text = jQuery('#word_count').val();
        len = text.split(/[\s]+/);
	/*if (len.length > wordLen) { 
            if ( event.keyCode == 46 || event.keyCode == 8 ) {// Allow backspace and delete buttons
            } else if (event.keyCode < 48 || event.keyCode > 57 ) {//all other buttons
                event.preventDefault();
            }
	}*/
        
        if ( event.keyCode == 46 || event.keyCode == 8 ) {// Allow backspace and delete buttons
            if(text.length == 0 || text.length == 1){
                wordsLeft = (wordLen);
            }
            else{
                var filtered = len.filter(function (el) { 
                    return el; 
                });
                wordsLeft = (wordLen) - filtered.length;            
            }
        }
        else{
            if (len.length > wordLen) { 
               if ( event.keyCode == 46 || event.keyCode == 8 ) {// Allow backspace and delete buttons
               } else if (event.keyCode < 48 || event.keyCode > 57 ) {//all other buttons
                   event.preventDefault();
               }
           }
           
           var filtered = len.filter(function (el) { 
                return el; 
            });
            wordsLeft = (wordLen) - filtered.length;
        }
                
//        wordsLeft = (wordLen) - len.length;
	jQuery('#display_count').html(wordsLeft+ ' words left');
    });
    

    jQuery('input[name="rafasshop_product_selection"]').change(function(){
        var selected_type = jQuery(this).val();
        if(selected_type == 'other_providers'){
            jQuery('#product-selection-msg').show();
        }
        else{
            jQuery('#product-selection-msg').hide();
        }
    });

    //Display necklabel logo
    if(!jQuery('#necklabel').is(':checked')){
        jQuery('.necklabel-image').hide();
    }
    jQuery('#necklabel').change(function(){
        if(jQuery('#necklabel').is(':checked')){
            jQuery('.necklabel-image').slideDown();
        }
        else{
            jQuery('.necklabel-image').slideUp();
        }
    });
    

    /**
     * General/setting page necklabel image selection
     */
    jQuery(document).on('click', '#set_necklabel_image', function(e) {
        e.preventDefault();

        custom_uploader = wp.media({
            title: 'Insert image',
            library : {
                // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                type : 'image/png'
            },
            button: {
                text: 'Use this image' // button label text
            },
            multiple: false
        }).on('select', function() { // it also has "open" and "close" events
            var attachment = custom_uploader.state().get('selection').first().toJSON();

            if(attachment.mime != 'image/png'){
                jQuery('#necklabel-image-error').show();
            }
            else{
                jQuery('#necklabel-image-error').hide();
                jQuery('#preview-necklabel-image').attr( 'src', attachment.url );
                jQuery('#necklabel_image_url').val(attachment.url).change();
        
                jQuery('.remove-general-necklabel-media').remove();
                jQuery('#preview-necklabel-image').after('<a href="javascript:void(0)" class="remove-general-necklabel-media">'+translate_text.remove+'</a>');
                
            }
           
        }).open();        

    } );



    /**
     * General media to print image selection: front side
     */
    jQuery(document).on('click', '#set_custom_images', function(e) {
        e.preventDefault();
        var this_btn = this;

        custom_uploader = wp.media({
            title: 'Insert image',
            library : {
                // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                type : 'image/png'
            },
            button: {
                text: 'Use this image' // button label text
            },
            multiple: false
        }).on('select', function() { // it also has "open" and "close" events
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            if(attachment.mime != 'image/png'){
                jQuery('#set_custom_images_error').show();
            }
            else{
                jQuery('#set_custom_images_error').hide();

                jQuery('#preview-custom-image').attr( 'src', attachment.url );
                jQuery('#general_media_to_print_url').val(attachment.url).change();

                jQuery('.remove-front-media').remove();
                jQuery('#preview-custom-image').after('<a href="javascript:void(0)" class="remove-front-media">'+translate_text.remove+'</a>');
            }
            
        }).open();
        
    } );



    /**
     * General thumbnail image selection
     */
    jQuery(document).on('click', '#thumbnail_preview_url', function(e) {
        e.preventDefault();

        custom_uploader = wp.media({
            title: 'Insert image',
            library : {
                // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                type : 'image/jpeg'
            },
            button: {
                text: 'Use this image' // button label text
            },
            multiple: false
        }).on('select', function() { // it also has "open" and "close" events
            var attachment = custom_uploader.state().get('selection').first().toJSON();

            if(attachment.mime != 'image/jpeg'){
                jQuery('#thumbnail_preview_url_error').show();
            }
            else{
                jQuery('#thumbnail_preview_url_error').hide();

                jQuery('#thumbnail_preview-custom-image').attr( 'src', attachment.url );
                jQuery('#general_thumbnail_preview_url').val(attachment.url).change();

                jQuery('.remove-front-thumbnail').remove();
                jQuery('#thumbnail_preview-custom-image').after('<a href="javascript:void(0)" class="remove-front-thumbnail">'+translate_text.remove+'</a>');
            }
        }).open();

    } );


    /**
     * General media to print image selection: front side
     */
    jQuery(document).on('click', '#set_custom_images_back_side', function(e) {
        e.preventDefault();

        custom_uploader = wp.media({
            title: 'Insert image',
            library : {
                // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                type : 'image/png'
            },
            button: {
                text: 'Use this image' // button label text
            },
            multiple: false
        }).on('select', function() { // it also has "open" and "close" events
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            if(attachment.mime != 'image/png'){
                jQuery('#set_custom_images_back_side_error').show();
            }
            else{
                jQuery('#set_custom_images_back_side_error').hide();
                jQuery('#preview-custom-image-back-side').attr( 'src', attachment.url );
                jQuery('#general_media_to_print_url_back_side').val(attachment.url).change();

                jQuery('.remove-back-media').remove();
                jQuery('#preview-custom-image-back-side').after('<a href="javascript:void(0)" class="remove-back-media">'+translate_text.remove+'</a>');

            }
            
        }).open();
        
    } );


    /**
     * General thumbnail image selection: Back side
     */
    jQuery(document).on('click', '#thumbnail_preview_url_back_side', function(e) {
        e.preventDefault();

        custom_uploader = wp.media({
            title: 'Insert image',
            library : {
                // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                type : 'image/jpeg'
            },
            button: {
                text: 'Use this image' // button label text
            },
            multiple: false
        }).on('select', function() { // it also has "open" and "close" events
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            
            if(attachment.mime != 'image/jpeg'){
                jQuery('#thumbnail_preview_url_back_side_error').show();
            }
            else{
                jQuery('#thumbnail_preview_url_back_side_error').hide();

                jQuery('#thumbnail_preview-custom-image-back-side').attr( 'src', attachment.url );
                jQuery('#general_thumbnail_preview_url_back_side').val(attachment.url).change();

                jQuery('.remove-back-thumbnail').remove();
                jQuery('#thumbnail_preview-custom-image-back-side').after('<a href="javascript:void(0)" class="remove-back-thumbnail">'+translate_text.remove+'</a>');
            }
        }).open();

    } );



    jQuery('#general_product_default_image_for_url').change(function(){
        if(jQuery(this).is(':checked')){
            jQuery('#general_thumbnail_preview_block').slideUp();
        }
        else{
            jQuery('#general_thumbnail_preview_block').slideDown();
        }
    });

    jQuery('#general_product_default_image_for_url_back_side').change(function(){
        if(jQuery(this).is(':checked')){
            jQuery('#general_thumbnail_preview_block_back_side').slideUp();
        }
        else{
            jQuery('#general_thumbnail_preview_block_back_side').slideDown();
        }
    });


    //Disabled rafasshop sku in simple product general field.
    jQuery(document).on('click','#general_product_sku_as_rafasshop',function(){
        if(jQuery(this).is(':checked')){
           jQuery('#general_rafasshop_sku').attr({'disabled':true,'readonly':true});
        }
        else{
            jQuery('#general_rafasshop_sku').attr({'disabled':false,'readonly':false});
        }
    });


    jQuery(document).on('click','.remove-front-media',function(){
        jQuery(this).siblings('#preview-custom-image').attr('src','');
        jQuery('#general_media_to_print_url').val('').change();
        jQuery(this).hide();
    });

    jQuery(document).on('click','.remove-front-thumbnail',function(){
        jQuery(this).siblings('#thumbnail_preview-custom-image').attr('src','');
        jQuery('#general_thumbnail_preview_url').val('').change();
        jQuery(this).hide();
    });

        
    jQuery(document).on('click','.remove-back-media',function(){
        jQuery(this).siblings('#preview-custom-image-back-side').attr('src','');
        jQuery('#general_media_to_print_url_back_side').val('').change();
        jQuery(this).hide();
    });

    jQuery(document).on('click','.remove-back-thumbnail',function(){
        jQuery(this).siblings('#thumbnail_preview-custom-image-back-side').attr('src','');
        jQuery('#general_thumbnail_preview_url_back_side').val('').change();
        jQuery(this).hide();
    });

    jQuery(document).on('click','.remove-general-necklabel-media',function(){
        jQuery(this).siblings('#preview-necklabel-image').attr('src','');
        jQuery('#necklabel_image_url').val('').change();
        jQuery(this).hide();
    });
            
});


/**
 * Hide/Show thumbnail preview block.
 *  
 */
function display_thumbnail_preview_block(variation_id, this_btn){
    var block_id = variation_id;

    if(jQuery(this_btn).is(':checked')){
        jQuery('#thumbnail_preview_block\\['+block_id+'\\]').slideUp();
    }
    else{
        jQuery('#thumbnail_preview_block\\['+block_id+'\\]').slideDown();
    }
}

function display_thumbnail_preview_block_back_side(variation_id, this_btn){
    var block_id = variation_id;

    if(jQuery(this_btn).is(':checked')){
        jQuery('#thumbnail_preview_block_back_side\\['+block_id+'\\]').slideUp();
    }
    else{
        jQuery('#thumbnail_preview_block_back_side\\['+block_id+'\\]').slideDown();
    }
}

/**
 * Media to print url image selection.
 * 
 */
function image_upload_function(variation_id , this_btn){
    
    var image_id = variation_id;

    var button = jQuery(this_btn),
    custom_uploader = wp.media({
        title: 'Insert image',
        library : {
            // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
            type : 'image/png'
        },
        button: {
            text: 'Use this image' // button label text
        },
        multiple: false
    }).on('select', function() { // it also has "open" and "close" events
        var attachment = custom_uploader.state().get('selection').first().toJSON();

        if(attachment.mime != 'image/png'){
            button.after('<span id="front-media'+image_id+'" class="rafasshop-required">please select .png image file.</span>');
        }
        else{
            jQuery("#front-media"+image_id).remove();
    
            button.html('<img id="variation-front-media-image'+image_id+'" src="' + attachment.url + '" width="50px" height="50px" alt="'+translate_text.upload_front_media+'">').next().val(attachment.id).next().show();

            jQuery("#remove-front-media"+image_id).remove();
            button.after('<a id="remove-front-media'+image_id+'" href="javascript:void(0)" onclick="remove_front_media_image_function( '+image_id+' , this );">'+translate_text.remove+'</a>');

            jQuery("#media_to_print_url\\["+image_id+"\\]").val(attachment.url).change();   
        }

    }).open();

}
//Remove Images from variations.
function remove_front_media_image_function(variation_id,this_btn){
    var image_id = variation_id;
    jQuery("#variation-front-media-image"+image_id).attr('src','');
    jQuery("#media_to_print_url\\["+image_id+"\\]").val('').change();
    jQuery('#remove-front-media'+image_id).remove();
}


function back_media_image_upload_function(variation_id , this_btn){
    
    var image_id = variation_id;

    var button = jQuery(this_btn),
    custom_uploader = wp.media({
        title: 'Insert image',
        library : {
            // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
            type : 'image/png'
        },
        button: {
            text: 'Use this image' // button label text
        },
        multiple: false
    }).on('select', function() { // it also has "open" and "close" events
        var attachment = custom_uploader.state().get('selection').first().toJSON();
        if(attachment.mime != 'image/png'){
            button.after('<span id="back-media'+image_id+'" class="rafasshop-required">please select .png image file.</span>');
        }
        else{
            jQuery("#back-media"+image_id).remove();
            button.html('<img id="variation-back-media-image'+image_id+'" src="' + attachment.url + '" width="50px" height="50px" alt="'+translate_text.upload_back_media+'">').next().val(attachment.id).next().show();

            jQuery("#remove-back-media"+image_id).remove();
            button.after('<a id="remove-back-media'+image_id+'" href="javascript:void(0)" onclick="remove_back_media_image_function( '+image_id+' , this );">'+translate_text.remove+'</a>');

            jQuery("#media_to_print_url_back_side\\["+image_id+"\\]").val(attachment.url).change();
        }
    }).open();

}
//Remove Images from variations.
function remove_back_media_image_function(variation_id,this_btn){
    var image_id = variation_id;
    jQuery("#variation-back-media-image"+image_id).attr('src','');
    jQuery("#media_to_print_url_back_side\\["+image_id+"\\]").val('').change();
    jQuery('#remove-back-media'+image_id).remove();
}


/**
 * Thumbnail preview url image selection.
 * 
 */
function thumbnail_preview_image_upload_function(variation_id,this_btn){
    
    var image_id = variation_id;

    var button = jQuery(this_btn),
    custom_uploader = wp.media({
        title: 'Insert image',
        library : {
            // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
            type : 'image/jpeg'
        },
        button: {
            text: 'Use this image' // button label text
        },
        multiple: false
    }).on('select', function() { // it also has "open" and "close" events
        var attachment = custom_uploader.state().get('selection').first().toJSON();
        if(attachment.mime != 'image/jpeg'){
            button.after('<span id="front-thumbnail'+image_id+'" class="rafasshop-required">please select .jpeg image file.</span>');
        }
        else{
            jQuery("#front-thumbnail"+image_id).remove();
            button.html('<img id="variation-front-thumbnail-image'+image_id+'" src="' + attachment.url + '" width="50px" height="50px" alt="'+translate_text.upload_front_thumbnail+'">').next().val(attachment.id).next().show();

            jQuery("#remove-front-thumbnail"+image_id).remove();
            button.after('<a id="remove-front-thumbnail'+image_id+'" href="javascript:void(0)" onclick="remove_front_thumbnail_image_function( '+image_id+' , this );">'+translate_text.remove+'</a>');

            jQuery("#thumbnail_preview_url\\["+image_id+"\\]").val(attachment.url).change();
        }
    }).open();
}
//Remove Images from variations.
function remove_front_thumbnail_image_function(variation_id,this_btn){
    var image_id = variation_id;
    jQuery("#variation-front-thumbnail-image"+image_id).attr('src','');
    jQuery("#thumbnail_preview_url\\["+image_id+"\\]").val('').change();
    jQuery('#remove-front-thumbnail'+image_id).remove();
}


function back_thumbnail_preview_image_upload_function(variation_id,this_btn){
    
    var image_id = variation_id;

    var button = jQuery(this_btn),
    custom_uploader = wp.media({
        title: 'Insert image',
        library : {
            // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
            type : 'image/jpeg'
        },
        button: {
            text: 'Use this image' // button label text
        },
        multiple: false
    }).on('select', function() { // it also has "open" and "close" events
        var attachment = custom_uploader.state().get('selection').first().toJSON();
        if(attachment.mime != 'image/jpeg'){
            button.after('<span id="back-thumbnail'+image_id+'" class="rafasshop-required">please select .jpeg image file.</span>');
        }
        else{
            jQuery("#back-thumbnail"+image_id).remove();
            button.html('<img id="variation-back-thumbnail-image'+image_id+'" src="' + attachment.url + '" width="50px" height="50px" alt="'+translate_text.upload_back_thumbnail+'">').next().val(attachment.id).next().show();

            jQuery("#remove-back-thumbnail"+image_id).remove();
            button.after('<a id="remove-back-thumbnail'+image_id+'" href="javascript:void(0)" onclick="remove_back_thumbnail_image_function( '+image_id+' , this );">'+translate_text.remove+'</a>');

            jQuery("#thumbnail_preview_url_back_side\\["+image_id+"\\]").val(attachment.url).change();
        }
    }).open();
}
//Remove Images from variations.
function remove_back_thumbnail_image_function(variation_id,this_btn){
    var image_id = variation_id;
    jQuery("#variation-back-thumbnail-image"+image_id).attr('src','');
    jQuery("#thumbnail_preview_url_back_side\\["+image_id+"\\]").val('').change();
    jQuery('#remove-back-thumbnail'+image_id).remove();
}

/**
 * Necklabel image selection.
 * 
 */
function necklabel_image_upload_function(variation_id,this_btn){
    
    var image_id = variation_id;
    var button = jQuery(this_btn),
    custom_uploader = wp.media({
        title: 'Insert image',
        library : {
            // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
            type : 'image/png'
        },
        button: {
            text: 'Use this image' // button label text
        },
        multiple: false
    }).on('select', function() { // it also has "open" and "close" events
        var attachment = custom_uploader.state().get('selection').first().toJSON();
        if(attachment.mime != 'image/png'){
            button.after('<span id="necklabel-error'+image_id+'" class="rafasshop-required">please select .png image file.</span>');
        }
        else{
            jQuery("#necklabel-error"+image_id).remove();
            button.html('<img id="variation-necklabel-image'+image_id+'" src="' + attachment.url + '" width="50px" height="50px" alt="'+translate_text.necklabel_image+'">').next().val(attachment.id).next().show();

            jQuery("#remove-necklabel"+image_id).remove();
            button.after('<a id="remove-necklabel'+image_id+'" href="javascript:void(0)" onclick="remove_variation_necklabel_image_function( '+image_id+' , this );">'+translate_text.remove+'</a>');

            jQuery("#necklabel_image_url\\["+image_id+"\\]").val(attachment.url).change();
        }
    }).open();
}

//Remove Images from variations.
function remove_variation_necklabel_image_function(variation_id,this_btn){
    var image_id = variation_id;
    jQuery("#variation-necklabel-image"+image_id).attr('src','');
    jQuery("#necklabel_image_url\\["+image_id+"\\]").val('').change();
    jQuery('#remove-necklabel'+image_id).remove();
}

//Disabled rafasshop sku in simple product general field.
function variation_disable_product_sku_as_rafasshop_fn(variation_id,this_btn){
    var image_id = variation_id;
    jQuery(document).on('click','#variation_product_sku_as_rafasshop\\['+image_id+'\\]',function(){
        if(jQuery(this).is(':checked')){
           jQuery('#rafasshop_sku\\['+image_id+'\\]').attr({'disabled':true,'readonly':true});
        }
        else{
            jQuery('#rafasshop_sku\\['+image_id+'\\]').attr({'disabled':false,'readonly':false});
        }
    });
}


