<?php

defined('ABSPATH') or die('No script kiddies please!');

/**
 * Add custom fields for product variations
 */

// Add Variation Settings
add_action( 'woocommerce_product_after_variable_attributes', 'variation_settings_fields', 10, 3 );

// Save Variation Settings
add_action( 'woocommerce_save_product_variation', 'save_variation_settings_fields', 10, 2 );

/**
 * Create new fields for variations
 *
*/
function variation_settings_fields( $loop, $variation_data, $variation ) {

    echo '<div class="product_custom_field">';
    
    echo '<div class="block-variation var1">';
    
    if(get_option('rafasshop_product_selection') != 'rafasshop_product' ){
        woocommerce_wp_checkbox(
        array(
            'id'            => 'is_rafasshop_product['.$variation->ID.']',
            'label'         => __('Rafasshop product','wc_reo' ),
            'value'         => get_post_meta( $variation->ID, 'is_rafasshop_product', true ),
            )
        );        
    }
    
    echo '</div>';
    
    echo '<div class="block-variation var2">';
    /**
     * Rafasshop SKU
     */

    $args_rafasshop_sku = array( 
        'id'          => 'rafasshop_sku[' . $variation->ID . ']', 
        'label'       => __( 'Rafasshop SKU', 'wc_reo' ), 
        'desc_tip'    => 'true',
        'description' => __( 'Enter the rafasshop SKU here.', 'wc_reo' ),
        'value' => get_post_meta( $variation->ID, 'rafasshop_sku', true ) 
    );
    if(get_option('product_sku_as_rafasshop') == 1 || get_post_meta( $variation->ID, 'variation_product_sku_as_rafasshop', true ) == "yes"){
        $args_rafasshop_sku['custom_attributes'] = array('readonly' => 'readonly','disabled' => 'disabled');
    }
    
    woocommerce_wp_text_input($args_rafasshop_sku);

    if(get_option('product_sku_as_rafasshop') != 1){
        $checkbox_for_product_sku_as_rafasshop = get_post_meta( $variation->ID, 'variation_product_sku_as_rafasshop', true );
        if($checkbox_for_product_sku_as_rafasshop == "yes"){
            $sku_checkbox_checked = "checked";
        }
        else{
            $sku_checkbox_checked = "";
        }
        ?>
        <p class="form-field variation_product_sku_as_rafasshop[<?php echo $variation->ID; ?>]_field ">
            <label for="variation_product_sku_as_rafasshop[<?php echo $variation->ID ?>]"><?php _e('Use SKU of this variation (must match with Rafasshop SKU)','wc_reo'); ?></label>

            <input type="checkbox" id="variation_product_sku_as_rafasshop[<?php echo $variation->ID ?>]"
            class="checkbox" name="variation_product_sku_as_rafasshop[<?php echo $variation->ID ?>]"
            <?php echo $sku_checkbox_checked; ?>
            
            onclick="variation_disable_product_sku_as_rafasshop_fn(<?php echo $variation->ID;?>,this);"
            />
        </p>
    <?php
    }
    
    echo '</div>';
    /** END: Rafasshop SKU */
    

    /**
     * Media to print url: Front side
     */
    echo '<div class="block-variation var3">';
	woocommerce_wp_text_input( 
		array( 
            'id' => 'media_to_print_url[' . $variation->ID . ']', 
            'class' => 'media_to_print',
                'label'       => __( 'Front Media to print URL (Allowed filetype: PNG)', 'wc_reo' ), 
                'placeholder' => 'https://',
                'desc_tip'    => 'true',
                'description' => __( 'Enter the rafasshop media to print url here.', 'wc_reo' ),
                'value'       => get_post_meta( $variation->ID, 'media_to_print_url', true )
            )
    );

        $image_uploded_url = get_post_meta( $variation->ID, 'media_to_print_url', true );
        $design_number = get_post_meta( $variation->ID, 'design_number', true ) ? get_post_meta( $variation->ID, 'design_number', true ) : "";
        if(!empty($image_uploded_url)){
            ?>
            <a href="#" onclick="image_upload_function( <?php echo $variation->ID; ?> , this );"><img id="variation-front-media-image<?php echo $variation->ID;?>" src="<?php echo $image_uploded_url; ?>" alt="Upload Front media" width="50px" height="50px"></a>
            <a id="remove-front-media<?php echo $variation->ID;?>" href="javascript:void(0)" onclick="remove_front_media_image_function( <?php echo $variation->ID; ?> , this );"><?php _e('remove','wc_reo');?></a>
        <?php
        }
        else{
            ?>
            <a href="#" onclick="image_upload_function( <?php echo $variation->ID; ?> , this );"><?php _e('Upload Front media','wc_reo'); ?></a>
            <?php
        }    
    /** END: Media to print url: Front side */

    /**
     * Use Product default image for thumbnail url
     */
    $checkbox_for_preview = get_post_meta( $variation->ID, 'product_default_image_for_url', true );
    if($checkbox_for_preview == "yes"){
        $checkbox_checked = "checked";
        $style_display_box = "style='display:none'";
    }
    else{
        $checkbox_checked = "";
        $style_display_box = "";
    }
    ?>

<p class="form-field product_default_image_for_url[<?php echo $variation->ID; ?>]_field ">

    <label for="product_default_image_for_url[<?php echo $variation->ID ?>]"><?php _e('Use product variation image for URL of preview design','wc_reo'); ?></label>

    <input type="checkbox" id="product_default_image_for_url[<?php echo $variation->ID ?>]"
    class="checkbox" name="product_default_image_for_url[<?php echo $variation->ID ?>]" onclick="display_thumbnail_preview_block(<?php echo $variation->ID; ?> , this );"
    <?php echo $checkbox_checked; ?>
    />

</p>


<div id="thumbnail_preview_block[<?php echo $variation->ID; ?>]" <?php echo $style_display_box;?>>
<?php

woocommerce_wp_text_input( 
    array( 
        'id'          => 'thumbnail_preview_url[' . $variation->ID . ']', 
        'label'       => __( 'Front Thumbnail preview url (Allowed filetype: JPEG)', 'wc_reo' ), 
        'placeholder' => 'https://',
        'desc_tip'    => 'true',
        'description' => __( 'Enter the rafasshop thumbnail url here.', 'wc_reo' ),
        'value'       => get_post_meta( $variation->ID, 'thumbnail_preview_url', true )
    )
);

    $image_uploded_url = get_post_meta( $variation->ID, 'thumbnail_preview_url', true );
    if(!empty($image_uploded_url)){
        ?>
        <a href="#" onclick="thumbnail_preview_image_upload_function( <?php echo $variation->ID; ?> , this );"><img id="variation-front-thumbnail-image<?php echo $variation->ID;?>" src="<?php echo $image_uploded_url; ?>" alt="Upload Front thumbnail" width="50px" height="50px"></a>
        <a id="remove-front-thumbnail<?php echo $variation->ID;?>" href="javascript:void(0)" onclick="remove_front_thumbnail_image_function( <?php echo $variation->ID; ?> , this );"><?php _e('remove','wc_reo');?></a>
        <span class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>

    <?php
    }
    else{
        ?>
        <a href="#" onclick="thumbnail_preview_image_upload_function( <?php echo $variation->ID; ?> , this );"><?php _e('Upload Front thumbnail','wc_reo'); ?></a>
        <span class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>
            <?php
    }
?>
</div>

<?php
    echo '</div>';
/** END: Use Product default image for thumbnail url */


////////////////////////////////////// Back side: Start //////////////////////////////////////////
/**
 * Media to print url: Back side
 */
    echo '<div class="block-variation var4">';
    woocommerce_wp_text_input( 
        array( 
        'id' => 'media_to_print_url_back_side[' . $variation->ID . ']', 
        'class' => 'media_to_print_back_side',
        'label'       => __( 'Back Media to print URL (Allowed filetype: PNG)', 'wc_reo' ), 
        'placeholder' => 'https://',
        'desc_tip'    => 'true',
        'description' => __( 'Enter the rafasshop back media to print url here.', 'wc_reo' ),
        'value'       => get_post_meta( $variation->ID, 'media_to_print_url_back_side', true )
    )
    );

    $image_uploded_url = get_post_meta( $variation->ID, 'media_to_print_url_back_side', true );
    if(!empty($image_uploded_url)){
        ?>
        <a href="#" onclick="back_media_image_upload_function( <?php echo $variation->ID; ?> , this );"><img id="variation-back-media-image<?php echo $variation->ID;?>" src="<?php echo $image_uploded_url; ?>" alt="Upload Back media" width="50px" height="50px"></a>
        <a id="remove-back-media<?php echo $variation->ID;?>" href="javascript:void(0)" onclick="remove_back_media_image_function( <?php echo $variation->ID; ?> , this );"><?php _e('remove','wc_reo');?></a>
        <span class="rafasshop-required" style="display:none"><?php _e('please select .png image file.','wc_reo');?></span>

    <?php
    }
    else{
        ?>
        <a href="#" onclick="back_media_image_upload_function( <?php echo $variation->ID; ?> , this );"><?php _e('Upload Back media','wc_reo'); ?></a>
        <span class="rafasshop-required" style="display:none"><?php _e('please select .png image file.','wc_reo');?></span>
        <?php
    }    
/** END: Media to print url: Back side */

/**
 * Use Product default image for thumbnail url: Back side
 */
    $checkbox_for_preview_back_side = get_post_meta( $variation->ID, 'product_default_image_for_url_back_side', true );
    if($checkbox_for_preview_back_side == "yes"){
        $checkbox_checked = "checked";
        $style_display_box = "style='display:none'";
    }
    else{
        $checkbox_checked = "";
        $style_display_box = "";
    }
    ?>

<p class="form-field product_default_image_for_url_back_side[<?php echo $variation->ID; ?>]_field ">

    <label for="product_default_image_for_url_back_side[<?php echo $variation->ID ?>]"><?php _e('Use product variation image for URL of preview design in back side','wc_reo'); ?></label>

    <input type="checkbox" id="product_default_image_for_url_back_side[<?php echo $variation->ID ?>]"
    class="checkbox" name="product_default_image_for_url_back_side[<?php echo $variation->ID ?>]" onclick="display_thumbnail_preview_block_back_side(<?php echo $variation->ID; ?> , this );"
    <?php echo $checkbox_checked; ?>
    />

</p>


<div id="thumbnail_preview_block_back_side[<?php echo $variation->ID; ?>]" <?php echo $style_display_box;?>>
<?php

woocommerce_wp_text_input( 
    array( 
        'id'          => 'thumbnail_preview_url_back_side[' . $variation->ID . ']', 
        'label'       => __( 'Back Thumbnail preview url (Allowed filetype: JPEG)', 'wc_reo' ), 
        'placeholder' => 'https://',
        'desc_tip'    => 'true',
        'description' => __( 'Enter the rafasshop back thumbnail url here.', 'wc_reo' ),
        'value'       => get_post_meta( $variation->ID, 'thumbnail_preview_url_back_side', true )
    )
);

    $image_uploded_url_back_side = get_post_meta( $variation->ID, 'thumbnail_preview_url_back_side', true );
    if(!empty($image_uploded_url_back_side)){
        ?>
        <a href="#" onclick="back_thumbnail_preview_image_upload_function( <?php echo $variation->ID; ?> , this );"><img id="variation-back-thumbnail-image<?php echo $variation->ID;?>" src="<?php echo $image_uploded_url_back_side; ?>" alt="Upload Back thumbnail" width="50px" height="50px"></a>
        <a id="remove-back-thumbnail<?php echo $variation->ID;?>" href="javascript:void(0)" onclick="remove_back_thumbnail_image_function( <?php echo $variation->ID; ?> , this );"><?php _e('remove','wc_reo');?></a>
        <span class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>

    <?php
    }
    else{
        ?>
        <a href="#" onclick="back_thumbnail_preview_image_upload_function( <?php echo $variation->ID; ?> , this );"><?php _e('Upload Back thumbnail','wc_reo'); ?></a>
        <span class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>
        <?php
    }
?>
</div>

<?php
echo '</div>';
/** END: Use Product default image for thumbnail url: Back side */

////////////////////////////////////// Back side: End //////////////////////////////////////////


/**
* Necklabel Image
*/
echo '<div class="block-variation var5">';
?>
<div id="necklabel_image_block[<?php echo $variation->ID; ?>]" <?php echo $necklabel_display_box;?>>
    
    <p class="notice-message"><b><?php _e('We will use this image as your necklabel logo for this product variation. If you don\'t add any image here, we will use the provided on general settings. If you don\'t add image on general setttings, we will not print any custom necklabel.  Print custom necklabel cost: +1.95€ (Allowed filetype: PNG)','wc_reo'); ?></b></p>

    <?php

    $necklabel_image_uploded_url = get_post_meta( $variation->ID, 'necklabel_image_url', true );
    if(!empty($necklabel_image_uploded_url)){
        ?>
        <a href="#" onclick="necklabel_image_upload_function( <?php echo $variation->ID; ?> , this );"><img id="variation-necklabel-image<?php echo $variation->ID;?>" src="<?php echo $necklabel_image_uploded_url; ?>" alt="Necklabel Image" width="50px" height="50px"></a>
        <a id="remove-necklabel<?php echo $variation->ID;?>" href="javascript:void(0)" onclick="remove_variation_necklabel_image_function( <?php echo $variation->ID; ?> , this );"><?php _e('remove','wc_reo');?></a>
    <?php
    woocommerce_wp_hidden_input(
        array( 
            'id'    => 'necklabel_image_url[' . $variation->ID . ']', 
            'value' => ''
            )
        );
    }
    else{
        ?>
        <a href="#" onclick="necklabel_image_upload_function( <?php echo $variation->ID; ?> , this );"><?php _e('Necklabel Image','wc_reo'); ?></a>
        <?php
        woocommerce_wp_hidden_input(
            array( 
                'id'    => 'necklabel_image_url[' . $variation->ID . ']', 
                'value' => ''
                )
            );
    }
    
    echo'</div>';
    echo '</div>';
    
    /** END: Necklabel Image */
    
    
    // Start: Distance to start printing from top in front/back side
    echo '<div class="block-variation var6">';
    
        $args_printing_top_in_front = array( 
            'id'          => 'variation_design_top_position_front[' . $variation->ID . ']', 
            'placeholder' => '0',
            'label' => __('Distance to start printing from top in front side (cm)', 'wc_reo'),
            'type' => 'number',
            'custom_attributes' => array(
                'min' => '0',
                'max' => '99'
            ),
            'value' => get_post_meta( $variation->ID, 'variation_design_top_position_front', true )
        );

        woocommerce_wp_text_input($args_printing_top_in_front);
        
        $args_printing_top_in_back = array( 
            'id'          => 'variation_design_top_position_back[' . $variation->ID . ']', 
            'placeholder' => '0',
            'label' => __('Distance to start printing from top in back side (cm)', 'wc_reo'),
            'type' => 'number',
            'custom_attributes' => array(
                'min' => '0',
                'max' => '99'
            ),
            'value' => get_post_meta( $variation->ID, 'variation_design_top_position_back', true )
        );

        woocommerce_wp_text_input($args_printing_top_in_back);
        
        ?>
        <p class="notice-message"><?php _e('This is the default distance to start printing from the top for this variation. Will override the information in the general setup.', 'wc_reo'); ?></p>
        <p><a class="document-link" href="https://www.rafasshop.es/especificar-la-posicion-del-diseno/" target="_blank"><?php _e('More info', 'wc_reo' ); ?></a></p>
        <?php
    
    echo '</div>';
    // END: Distance to start printing from top in front/back side
    
    // Start: PRINTING METHOD
    echo '<div class="block-variation var7">';
        $default_printing_status = rafasshopDefaultPrintingMethods();
        $selected_printing_method = isset($default_printing_status[get_post_meta( $variation->ID, 'rafasshop_printing_method', true )]) ? get_post_meta( $variation->ID, 'rafasshop_printing_method', true ) : 'direct_print';
        $args_printing_methods = array(
            'id' => 'rafasshop_printing_method[' . $variation->ID . ']',
            'label' => __('Please, select the default printing method:', 'wc_reo'),
            'options' => $default_printing_status,
            'value' => $selected_printing_method
        );
        
        woocommerce_wp_select($args_printing_methods);
        ?>
        <p class="notice-message"><?php _e('<b>NOTE:</b> This is the printing method for this product variation, so you can select different printing method in each design/product.', 'wc_reo'); ?></p>
        <p class="notice-message"><?php _e('<b>VERY IMPORTANT:</b> For dropshipping we always use the "direct print" method. If you want to use different printing methods, please, contact us to see your exact needs and based on your designs, selected products, etc.', 'wc_reo'); ?></p>
        <?php
    echo '</div>';
    // END: PRINTING METHOD
    
echo '</div>';
}



/**
 * Save new fields for variations
 *
*/
function save_variation_settings_fields( $post_id ) {

    $is_rafasshop_product = isset( $_POST['is_rafasshop_product'][ $post_id ] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'is_rafasshop_product', $is_rafasshop_product );

    $rafasshop_sku = $_POST['rafasshop_sku'][ $post_id ];
    if( ! empty( $rafasshop_sku ) ) {
            update_post_meta( $post_id, 'rafasshop_sku', esc_attr( $rafasshop_sku ) );
    }

    $product_sku_as_rafasshop_checkbox = isset( $_POST['variation_product_sku_as_rafasshop'][ $post_id ] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'variation_product_sku_as_rafasshop', $product_sku_as_rafasshop_checkbox );

    
    ///// Front side ///////////
    $media_to_print_url = $_POST['media_to_print_url'][ $post_id ];
    update_post_meta( $post_id, 'media_to_print_url', esc_attr( $media_to_print_url ) );
    if( ! empty( $media_to_print_url ) ) {
        $design_number = pathinfo($media_to_print_url, PATHINFO_FILENAME);        
        update_post_meta( $post_id, 'design_number', esc_attr( $design_number ) );
    }
    
    // Checkbox
    $checkbox = isset( $_POST['product_default_image_for_url'][ $post_id ] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'product_default_image_for_url', $checkbox );
    
    if(isset( $_POST['product_default_image_for_url'][ $post_id ] )){
        $variation = new WC_Product_Variation( $post_id );
        $image_id = $variation->get_image_id();
        $src = wp_get_attachment_url( $image_id );

        update_post_meta( $post_id, 'thumbnail_preview_url', esc_attr( $src ) );

    }
    else{
        $thumbnail_preview_url = $_POST['thumbnail_preview_url'][ $post_id ];
        update_post_meta( $post_id, 'thumbnail_preview_url', esc_attr( $thumbnail_preview_url ) );
    }    
    ///// END: Front side ///////////
    

    ///// Back side ///////////
    $media_to_print_url_back_side = $_POST['media_to_print_url_back_side'][ $post_id ];
    update_post_meta( $post_id, 'media_to_print_url_back_side', esc_attr( $media_to_print_url_back_side ) );
    
    // Checkbox
    $checkbox_back_side = isset( $_POST['product_default_image_for_url_back_side'][ $post_id ] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'product_default_image_for_url_back_side', $checkbox_back_side );
    
    if(isset( $_POST['product_default_image_for_url_back_side'][ $post_id ] )){
        $variation = new WC_Product_Variation( $post_id );
        $image_id = $variation->get_image_id();
        $src = wp_get_attachment_url( $image_id );

        update_post_meta( $post_id, 'thumbnail_preview_url_back_side', esc_attr( $src ) );

    }
    else{
        $back_thumbnail_preview_url = $_POST['thumbnail_preview_url_back_side'][ $post_id ];
        update_post_meta( $post_id, 'thumbnail_preview_url_back_side', esc_attr( $back_thumbnail_preview_url ) );
    }    
    ///// END: Back side ///////////

    
    $necklabel_image_url = $_POST['necklabel_image_url'][ $post_id ];
    update_post_meta( $post_id, 'necklabel_image_url', esc_attr( $necklabel_image_url ) );
    
    // Start: Distance to start printing from top in front/back side
    $variation_design_top_position_front = $_POST['variation_design_top_position_front'][ $post_id ];
    if( $variation_design_top_position_front >= 0 && $variation_design_top_position_front <= 99 ){
        update_post_meta($post_id, 'variation_design_top_position_front', $variation_design_top_position_front);
    }
    
    $variation_design_top_position_back = $_POST['variation_design_top_position_back'][ $post_id ];
    if($variation_design_top_position_back >= 0 && $variation_design_top_position_back <= 99 ){
        update_post_meta($post_id, 'variation_design_top_position_back', $variation_design_top_position_back);
    }
    // End: Distance to start printing from top in front/back side
    
    $rafasshop_printing_method = $_POST['rafasshop_printing_method'][ $post_id ];
    update_post_meta($post_id, 'rafasshop_printing_method', $rafasshop_printing_method);

}

